<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login(['admin','manager']);

$in = rp_json_input();
$id    = isset($in['id']) ? (int)$in['id'] : 0;
$type  = in_array(($in['type'] ?? ''), ['activity','notice','special'], true) ? $in['type'] : null;
$title = trim((string)($in['title'] ?? ''));
$msg   = trim((string)($in['message'] ?? ''));
$scope = in_array(($in['scope'] ?? ''), ['global','department','user'], true) ? $in['scope'] : 'global';
$start = $in['start_at'] ?? null;
$end   = $in['end_at'] ?? null;
$deptIds = is_array($in['department_ids'] ?? null) ? array_values(array_unique(array_map('intval',$in['department_ids']))) : [];
$userIds = is_array($in['user_ids'] ?? null) ? array_values(array_unique(array_map('intval',$in['user_ids']))) : [];

if (!$type) rp_json(['ok'=>false,'error'=>'Ongeldig type'],422);
if ($title === '') rp_json(['ok'=>false,'error'=>'Titel is verplicht'],422);
if ($scope === 'department' && empty($deptIds)) rp_json(['ok'=>false,'error'=>'Kies minimaal één afdeling'],422);
if ($scope === 'user' && empty($userIds)) rp_json(['ok'=>false,'error'=>'Kies minimaal één gebruiker'],422);

try{
  $pdo->beginTransaction();

  if ($id>0){
    $pdo->prepare("UPDATE announcements SET type=?, title=?, message=?, scope=?, start_at=?, end_at=?, updated_at=NOW() WHERE id=?")
        ->execute([$type,$title,($msg?:null),$scope,($start?:null),($end?:null),$id]);
    $pdo->prepare("DELETE FROM announcement_departments WHERE announcement_id=?")->execute([$id]);
    $pdo->prepare("DELETE FROM announcement_users WHERE announcement_id=?")->execute([$id]);
  } else {
    $pdo->prepare("INSERT INTO announcements (type,title,message,scope,start_at,end_at,created_by) VALUES (?,?,?,?,?,?,?)")
        ->execute([$type,$title,($msg?:null),$scope,($start?:null),($end?:null), $_SESSION['user']['id'] ?? null]);
    $id = (int)$pdo->lastInsertId();
  }

  if ($scope==='department' && $deptIds){
    $ins = $pdo->prepare("INSERT INTO announcement_departments (announcement_id,department_id) VALUES (?,?)");
    foreach ($deptIds as $d) $ins->execute([$id,$d]);
  }
  if ($scope==='user' && $userIds){
    $ins = $pdo->prepare("INSERT INTO announcement_users (announcement_id,user_id) VALUES (?,?)");
    foreach ($userIds as $u) $ins->execute([$id,$u]);
  }

  $pdo->commit();
  rp_json(['ok'=>true,'id'=>$id]);
} catch(Exception $e){
  if ($pdo->inTransaction()) $pdo->rollBack();
  rp_json(['ok'=>false,'error'=>$e->getMessage()?:'Opslaan mislukt'],500);
}
